﻿//Copyright (C) Microsoft Corporation.  All rights reserved.

using System;
using System.Collections.Generic;
using System.Windows.Forms;
using SampleSupport;
using SampleQueries;
using System.IO;

namespace SampleQueries
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            List<SampleHarness> harnesses = new List<SampleHarness>()
            {
                new Chapter01Samples(),
                new Chapter02Samples(),
                new Chapter03Samples(),
                new Chapter04Samples(),
                new Chapter05Samples(),
                new Chapter06Samples(),
                new Chapter07Samples(),
                new Chapter08Samples(),
                new Chapter09Samples(),
                //new StatisticOperatorSamples()
            };
            
            if (args.Length >= 1 && args[0] == "/runall")
            {
                foreach (SampleHarness harness in harnesses)
                {
                    harness.RunAllSamples();
                }
            }
            else {
                Application.EnableVisualStyles();
                
                using (SampleForm form = new SampleForm("LINQ to Object using C# 4.0 (including PLINQ) Sample Browser", harnesses))
                {
                    form.ShowDialog();
                }
            }
        }
    }
}